//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "projman.h"
#include "Unit1.h"
#include "Unit2.h"
#include "add_data.h"
#include "inifiles.hpp"
#include <string.h>
#include <sysutils.hpp>
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TProjectMgr *ProjectMgr;
//---------------------------------------------------------------------------
__fastcall TProjectMgr::TProjectMgr(TComponent* Owner)
    : TForm(Owner)
{
}
void __fastcall TProjectMgr::InitializeResourceTree()
{
//ResourceEdit->Lines->LoadFromFile( Form1->ProjectInfo.RCFile);

TStringList *Buffer;
TTreeNode *NewResNode, *MenuNode, *StringNode, *VersionNode;
TTreeNode *AccelNode, *BMPNode, *CursorNode, *DlgNode, *FontNode, *IconNode;
int x, y, *LinePtr;
AnsiString NodeData, NodeName;
Buffer = new TStringList;
VersionNode=ResourceTreeView->Items->AddFirst(NULL, "Version Info");
StringNode=ResourceTreeView->Items->AddFirst (NULL, "String Table");
MenuNode=ResourceTreeView->Items->AddFirst( NULL, "Menu");
IconNode=ResourceTreeView->Items->AddFirst( NULL, "Icon");
FontNode=ResourceTreeView->Items->AddFirst( NULL, "Font");
DlgNode=ResourceTreeView->Items->AddFirst( NULL, "Dialog");
CursorNode=ResourceTreeView->Items->AddFirst( NULL, "Cursor");
BMPNode=ResourceTreeView->Items->AddFirst( NULL, "Bitmap");
AccelNode=ResourceTreeView->Items->AddFirst( NULL, "Accelerator Table");
Buffer->LoadFromFile( Form1->ProjectInfo.Path + "\\" + Form1->ProjectInfo.RCFile);
for (x = 0; x < Buffer->Count; x++){
 if (strstr(Buffer->Strings[x].c_str(), "DIALOG") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( DlgNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
  else if (strstr(Buffer->Strings[x].c_str(), "FONT") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( FontNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "CURSOR") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( CursorNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "BITMAP") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( BMPNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "ACCELERATORS") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( AccelNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "ICON") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( IconNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "MENU") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( MenuNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "STRINGTABLE") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( StringNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
    else if (strstr(Buffer->Strings[x].c_str(), "VERSIONINFO") != NULL){
     NewResNode = ModuleTreeView->Items->AddChild( VersionNode, Buffer->Strings[x]);
     NewResNode->Data = Buffer->Strings[x].c_str();
  }
//else it is not a resource line...
}
}

void __fastcall TProjectMgr::InitializeDispatchTree()
{
TStringList *Buffer;
TTreeNode *NewTableNode, *NewMessageNode, *NewHandlerNode;
int x, y, LinePtr;
AnsiString NodeData, NodeName;
Buffer = new TStringList;
Buffer->LoadFromFile( Form1->ProjectInfo.Path + "\\" + Form1->ProjectInfo.MainProc);
for (x = 0; x < Buffer->Count; x++){
 if (Buffer->Strings[x] == ";Table"){
  //parse
  LinePtr = x + 1;
  NewTableNode = MessageTreeView->Items->Add(NULL, Buffer->Strings[LinePtr]);
  while (Buffer->Strings[++LinePtr] != ";EndTable"){
   //more parse
   NodeName = Buffer->Strings[LinePtr];
   NodeName = NodeName.TrimLeft();
   NodeName = NodeName.SubString( 7, (NodeName.Length() - 6));
   NodeName = NodeName.TrimLeft();
   NodeData = NodeName.SubString(NodeName.Pos(","),  NodeName.Length() );
   NodeData.Delete(1, 2);
   NodeData = NodeData.TrimLeft();
   NodeName.Delete(NodeName.Pos(","),  NodeName.Length() );
   if (NodeName == "-1") NodeName = "Default Handler";
   NewMessageNode = MessageTreeView->Items->AddChild(NewTableNode, NodeName);
   NewHandlerNode = MessageTreeView->Items->AddChild(NewMessageNode, NodeData);
   NewHandlerNode->Data =  NodeData.c_str();
   NewMessageNode->Data =  NodeData.c_str();
  }
 }
}
Buffer->Free();
}
void __fastcall TProjectMgr::InitializeModules()
{
 TTreeNode *NewNode, *AsmNode, *IncNode, *RcNode;
 AnsiString FileName;
 int x;
//Initialize Project Manager Tree
RcNode=ModuleTreeView->Items->AddFirst(NULL, "Resource Files (*.rc)");
IncNode=ModuleTreeView->Items->AddFirst (NULL, "Header Files (*.inc)");
AsmNode=ModuleTreeView->Items->AddFirst( NULL, "Source Files (*.asm)");
for (x = 0; x < Form1->ProjectInfo.AsmFiles->Count; x++){
 FileName = Form1->ProjectInfo.AsmFiles->Strings[x];
 NewNode = ModuleTreeView->Items->AddChild(AsmNode, FileName);
 NewNode->Data = FileName.c_str();
 NewNode->ImageIndex = 3;
 NewNode->SelectedIndex = 3;
}
for (x = 0; x < Form1->ProjectInfo.IncFiles->Count; x++){
 FileName = Form1->ProjectInfo.IncFiles->Strings[x];
 NewNode = ModuleTreeView->Items->AddChild( IncNode, FileName);
 NewNode->Data = FileName.c_str();
 NewNode->ImageIndex = 3;
 NewNode->SelectedIndex = 3;
}
for (x = 0; x < Form1->ProjectInfo.RcFiles->Count; x++){
 FileName = Form1->ProjectInfo.RcFiles->Strings[x];
 NewNode = ModuleTreeView->Items->AddChild( RcNode, FileName);
 NewNode->Data = FileName.c_str();
 NewNode->ImageIndex = 5;
 NewNode->SelectedIndex = 5;
}
//Add Make Node
if (Form1->ProjectInfo.MakeFile != ""){
 FileName = Form1->ProjectInfo.MakeFile;
 NewNode = ModuleTreeView->Items->Add(NULL, FileName);
 NewNode->ImageIndex = 4;
 NewNode->SelectedIndex = 4;
 NewNode->StateIndex = -1;
 NewNode->Data =  FileName.c_str();
}
//Add DEF Node
if (Form1->ProjectInfo.DefFile != ""){
 FileName = Form1->ProjectInfo.DefFile;
 NewNode = ModuleTreeView->Items->Add(NULL, FileName);
 NewNode->ImageIndex = 3;
 NewNode->SelectedIndex = 3;
 NewNode->StateIndex = -1;
 NewNode->Data = FileName.c_str();
}
//Add INI Node
NewNode = ModuleTreeView->Items->Add(NULL, "Project.ini");
NewNode->ImageIndex = 2;
NewNode->SelectedIndex = 2;
NewNode->StateIndex = -1;
NewNode->Data =  Form1->ProjectInfo.IniFile.c_str();
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::FormShow(TObject *Sender)
{
 RefreshTabs();
 PageControl1->ActivePage = ModuleTab;
}

//---------------------------------------------------------------------------
void __fastcall TProjectMgr::ModuleTreeViewDblClick(TObject *Sender)
{
//if(ModuleTreeView->Selected->Data != ""){
//    char *FileName =  (char *) ModuleTreeView->Selected->Data;
//    ShellExecute(NULL, "open", Form1->Tools.Text.c_str(), FileName, NULL, SW_SHOWNORMAL) ;
//    }
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::EditButtonClick(TObject *Sender)
{
 Form2->LoadFile( (char *) ModuleTreeView->Selected->Data);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::Edit1Click(TObject *Sender)
{
EditButtonClick(this);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::AddDataButtonClick(TObject *Sender)
{
 AddDataForm->Show();    
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::Button8Click(TObject *Sender)
{
 GlobalDataEdit->Lines->SaveToFile( Form1->ProjectInfo.MainData);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::ViewButtonClick(TObject *Sender)
{
 AnsiString CodeLabel =  (char *) MessageTreeView->Selected->Data;
 if (CodeLabel != ""){
  CodeLabel += ":";
  int x, LabelLoc;
  MessageTabEdit->Lines->Clear();
  MessageTabEdit->Lines->LoadFromFile( Form1->ProjectInfo.MainProc);
  LabelLoc = MessageTabEdit->Lines->IndexOf( CodeLabel );
  if (LabelLoc != -1 && LabelLoc < MessageTabEdit->Lines->Count) {
    for (x = 0; x < LabelLoc ; x++) MessageTabEdit->Lines->Delete(0);
  }
  else MessageTabEdit->Lines->Add("Not Found!");
 }
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::ClearTabs()
{
ModuleTreeView->Items->Clear();
MessageTreeView->Items->Clear();
ResourceTreeView->Items->Clear();
ResourceEdit->Lines->Clear();
GlobalDataEdit->Lines->Clear();
}
void __fastcall TProjectMgr::RefreshTabs()
{
	try{
    	ClearTabs();
        GlobalDataEdit->Lines->LoadFromFile( Form1->ProjectInfo.MainData);
 		InitializeModules();
 		InitializeResourceTree();
 		InitializeDispatchTree();
    }
    catch (...)
    {
    //
    }

}
void __fastcall TProjectMgr::ModPopup_Refresh_IDMClick(TObject *Sender)
{
RefreshTabs();
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::ResPopup_Refresh_IDMClick(TObject *Sender)
{
RefreshTabs();    
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::Button5Click(TObject *Sender)
{

  AnsiString ResToView =  (char*)ResourceTreeView->Selected->Data;
  int x, StrOffset;
  ResourceEdit->Lines->Clear();
  ResourceEdit->Lines->LoadFromFile( Form1->ProjectInfo.RCFile);
  StrOffset = ResourceEdit->Lines->IndexOf( ResToView);
  for (x = 0; x < StrOffset; x++) ResourceEdit->Lines->Delete(0);

}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::DataPopup_Add_IDMClick(TObject *Sender)
{
AddDataButtonClick(this);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::DataPopup_Save_IDMClick(TObject *Sender)
{
Button8Click(this);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::DataPopup_Refresh_IDMClick(TObject *Sender)
{
RefreshTabs();    
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::ResPopup_View_IDMClick(TObject *Sender)
{
Button5Click(this);
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::MessPopup_View_IDMClick(TObject *Sender)
{
ViewButtonClick(this);    
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::MessPopup_Refresh_IDMClick(TObject *Sender)
{
RefreshTabs();    
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::AddButtonClick(TObject *Sender)
{
 Form1->FileOpenDlg->Filter = "Asm source files (*.asm)|*.ASM|Header files (*.inc)|*.INC|Project files (*.ini)|*.INI|Resource files (*.rc)|*.RC";
 Form1->FileOpenDlg->FileName = "";
 if ( Form1->FileOpenDlg->Execute() ){
   TIniFile* IniFile = new TIniFile( Form1->ProjectInfo.IniFile);
   AnsiString AddFileType= ExtractFileExt(Form1->FileOpenDlg->FileName);
   if (AddFileType == ".rc"||AddFileType == ".RC") {
      IniFile->WriteString("RC Modules", ExtractFileName(Form1->FileOpenDlg->FileName), "");
      Form1->ProjectInfo.RcFiles->Clear();
      IniFile->ReadSection("RC Modules", Form1->ProjectInfo.RcFiles);
   }
   else if(AddFileType == ".inc"||AddFileType == ".INC") {
      IniFile->WriteString("INC Modules", ExtractFileName(Form1->FileOpenDlg->FileName), "");
      Form1->ProjectInfo.IncFiles->Clear();
      IniFile->ReadSection("INC Modules", Form1->ProjectInfo.IncFiles);
   }
   else  {
      IniFile->WriteString("ASM Modules", ExtractFileName(Form1->FileOpenDlg->FileName), "");
      Form1->ProjectInfo.AsmFiles->Clear();
      IniFile->ReadSection("ASM Modules", Form1->ProjectInfo.AsmFiles);
   }
   IniFile->Free();
   RefreshTabs();
 }
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::DeleteButtonClick(TObject *Sender)
{
 TIniFile* IniFile = new TIniFile( Form1->ProjectInfo.IniFile);
 ExtractFileName((char *)ModuleTreeView->Selected->Data);
 ExtractFileExt((char *)ModuleTreeView->Selected->Data);
 IniFile->Free();
 RefreshTabs();
}
//---------------------------------------------------------------------------
void __fastcall TProjectMgr::Button6Click(TObject *Sender)
{
//execute res edit
ShellExecute(NULL, "open", Form1->Tools.Res.c_str(), Form1->ProjectInfo.RCFile.c_str(), NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
